﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.DynamicData;
using System.Linq.Expressions;
using System.Diagnostics;

namespace DynamicDataEntities.DynamicData.Filters
{
  public partial class TextFilter : QueryableFilterUserControl
  {
    public override Control FilterControl
    {
      get
      {
        return this.textBox;
      }
    }
    public override IQueryable GetQueryable(IQueryable source)
    {
      if (string.IsNullOrEmpty(this.textBox.Text) || !this.validator.IsValid)
      {
        return source;
      }

      string filterValue = this.textBox.Text;
      ConstantExpression value = Expression.Constant(filterValue);

      ParameterExpression parameter = Expression.Parameter(source.ElementType);
      MemberExpression property = Expression.Property(parameter, this.Column.Name);
      if (Nullable.GetUnderlyingType(property.Type) != null)
      {
        property = Expression.Property(property, "Value");
      }


      Expression comparison;
      switch (this.dropDownList.SelectedValue)
      {
        case "contains":
          comparison = Expression.Call(property, typeof(string).GetMethod("Contains", new Type[] { typeof(string) }), value);
          break;
        case "start":
          comparison = Expression.Call(property, typeof(string).GetMethod("StartsWith", new Type[] { typeof(string) }), value);
          break;
        case "end":
          comparison = Expression.Call(property, typeof(string).GetMethod("EndsWith", new Type[] { typeof(string) }), value);
          break;
        default:
          Debug.Fail("Unexpected operator");
          return source;
      }

      LambdaExpression lambda = Expression.Lambda(comparison, parameter);

      MethodCallExpression where = Expression.Call(
                      typeof(Queryable),
                      "Where",
                      new Type[] { source.ElementType },
                      source.Expression,
                      lambda);

      return source.Provider.CreateQuery(where);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
      this.textBox.ToolTip = this.Column.Description;
      this.validator.ErrorMessage = "Invalid filter specified for " +
          this.Column.DisplayName;
      this.validator.ToolTip = this.validator.ErrorMessage;
    }

    protected void Validate(object sender, ServerValidateEventArgs e)
    {
      // apply your validation here...
      e.IsValid = true;
    }
  }
}