﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using RestCarService.Models;
using System.Web.Routing;

namespace RestCarService.Infrastructure
{
  public class CarMakeRouteConstraint : IRouteConstraint
  {
    private ICarsRepository repository = null;

    public CarMakeRouteConstraint(ICarsRepository repository)
    {
      this.repository = repository;
    }

    public bool Match(HttpContextBase httpContext, Route route, string parameterName, RouteValueDictionary values, RouteDirection routeDirection)
    {
      if (parameterName != "make")
      {
        return false;
      }

      object make = null;
      if (!values.TryGetValue("make", out make))
      {
        return false;
      }
      string makeString = make as string;
      if (null == makeString) return false;

      // check if requested make exists in the database
      var count = repository.Cars.Where(c => c.Make == makeString).Count() ;

      return count > 0;
    }
  }
}