﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

namespace RestCarService.Models
{
  public class EFCarsRepository : ICarsRepository
  {
    private CarsContext context = new CarsContext();

    public IQueryable<Car> Cars
    {
      get { return context.Cars; }
    }


    public void InsertCar(Car car)
    {
      context.Cars.Add(car);
      context.SaveChanges();
    }

    public void UpdateCar(Car car)
    {
      context.Cars.Attach(car);
      context.Entry(car).State = EntityState.Modified;
      context.SaveChanges();
    }

    public void DeleteCar(int id)
    {
      Car car = context.Cars.Find(id);
      context.Cars.Remove(car);
      context.SaveChanges();
    }
  }
}