﻿using System.Web.Mvc;
using System.Web.Routing;
using RestCarService.Infrastructure;
using RestCarService.Models;
using System.Data.Entity;
using Ninject;
using Ninject.Modules;

namespace RestCarService
{
  public class MvcApplication : System.Web.HttpApplication
  {
    private static IKernel kernel = new StandardKernel(new CarsConfigurationModule());

    private class CarsConfigurationModule : NinjectModule
    {
      public override void Load()
      { 
        Bind<ICarsRepository>().To<EFCarsRepository>();
      }
    }

    public static void RegisterGlobalFilters(GlobalFilterCollection filters)
    {
      filters.Add(new HandleErrorAttribute());
    }

    public static void RegisterRoutes(RouteCollection routes)
    {
      routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

      routes.MapRoute(
          name: "Cars"
        , url: "Cars/{make}/{minYear}/{maxMileage}"
        , defaults: new
        {
          controller = "Cars",
          action = "List",
          make = "All",
          minYear = "0000",
          maxMileage = "0km"
        }
        , constraints: new
        {
          make = kernel.Get<CarMakeRouteConstraint>(),
          minYear = @"\d{4}",
          maxMileage = @"\d+(km|mi)"
        });

      routes.MapRoute(
          name: "Cars2"
        , url: "Cars/{make}/{model}/{minYear}/{maxMileage}"
        , defaults: new
        {
          controller = "Cars",
          action = "List",
          make = "All",
          model = "All",
          minYear = "0000",
          maxMileage = "0km"
        }
        , constraints: new
        {
          make = kernel.Get<CarMakeRouteConstraint>(),
          minYear = @"\d{4}",
          maxMileage = @"\d+(km|mi)"
        });

      routes.MapRoute(
          name: "Cars3"
        , url: "Cars/{make}/{model}/{type}/{minYear}/{maxMileage}"
        , defaults: new
        {
          controller = "Cars",
          action = "List",
          make = "All",
          model = "All",
          type="All",
          minYear = "0000",
          maxMileage = "0km"
        }
        , constraints: new
        {
          make = kernel.Get<CarMakeRouteConstraint>(),
          minYear = @"\d{4}",
          maxMileage = @"\d+(km|mi)"
        });

      routes.MapRoute(
        name: "SingleCar"
        , url: "Car/{id}"
        , defaults: new
        {
          Controller="Cars",
          Action="Single",
          id=UrlParameter.Optional
        });

      routes.MapRoute(
        name: "SingleCarEdit"
        , url: "Car/Edit/{id}"
        , defaults: new
        {
          Controller = "Cars",
          Action = "Edit",
          id = UrlParameter.Optional
        });

      routes.MapRoute(
        name: "SingleCarDelete"
        , url: "Car/Delete/{id}"
        , defaults: new
        {
          Controller = "Cars",
          Action = "Delete",
          id = UrlParameter.Optional
        });

      routes.MapRoute(
        name:"Default"
        , url: "{controller}/{action}/{id}"
        , defaults:  new 
        { 
          controller = "Cars", 
          action = "List", 
          id = UrlParameter.Optional 
        });
    }

    protected void Application_Start()
    {
      AreaRegistration.RegisterAllAreas();

      RegisterGlobalFilters(GlobalFilters.Filters);
      RegisterRoutes(RouteTable.Routes);

      // set up dependency injection.
      ControllerBuilder.Current.SetControllerFactory(new NinjectControllerFactory(kernel));

      // set up the database
      Database.SetInitializer(new DropCreateDatabaseIfModelChanges<CarsContext>());
    }


  }
}