﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.SessionState;
using System.Web.Routing;
using Ninject;
using Ninject.Modules;
using RestCarService.Models;

namespace RestCarService.Infrastructure
{
	public class NinjectControllerFactory : DefaultControllerFactory
	{
    public NinjectControllerFactory(IKernel kernel)
    {
      this.kernel = kernel;
    }

    private IKernel kernel;

    protected override IController GetControllerInstance(RequestContext requestContext, Type controllerType)
    {
      if (controllerType == null)
      {
        return null;
      }
      return (IController)kernel.Get(controllerType);
    }

  }
}