﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace RestCarService.Infrastructure
{
  public class RestResult : ActionResult
  {
    private ActionResult actionResult;

    public RestResult(ActionResult actionResult, int statusCode, string statusDescription = null, string location = null)
    {
      this.actionResult = actionResult;
      StatusCode = statusCode;
      StatusDescription = statusDescription;
      Location = location;
    }


    public string Location { get; private set; }

    public int StatusCode { get; private set; }

    public string StatusDescription { get; private set; }

    public override void ExecuteResult(ControllerContext context)
    {
      if (null == context)
      {
        throw new ArgumentNullException("context");
      }

      context.HttpContext.Response.StatusCode = this.StatusCode;
      if (null != this.StatusDescription)
      {
        context.HttpContext.Response.StatusDescription = this.StatusDescription;
      }
      if (null != this.Location)
      {
        context.HttpContext.Response.AddHeader("Location", this.Location);
      }


      if (null != actionResult)
      {
        actionResult.ExecuteResult(context);
      }
    }
  }
}