/********************************************************************************
 *   This file is part of NRtfTree Library.
 *
 *   NRtfTree Library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   NRtfTree Library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.
 ********************************************************************************/

/********************************************************************************
 * Library:		NRtfTree
 * Version:     v0.3.0
 * Date:		01/05/2009
 * Copyright:   2006-2009 Salvador Gomez
 * E-mail:      sgoliver.net@gmail.com
 * Home Page:	http://www.sgoliver.net
 * SF Project:	http://nrtftree.sourceforge.net
 *				http://sourceforge.net/projects/nrtftree
 * Class:		RtfNodeCollection
 * Description:	Coleccin de nodos de un rbol RTF.
 * ******************************************************************************/

using System;
using System.Collections;

namespace Net.Sgoliver.NRtfTree
{
    namespace Core
    {
        /// <summary>
        /// Coleccin de nodos de un documento RTF.
        /// </summary>
        public class RtfNodeCollection : CollectionBase
        {
            #region Mtodos Publicos

            /// <summary>
            /// Aade un nuevo nodo a la coleccin actual.
            /// </summary>
            /// <param name="node">Nuevo nodo a aadir.</param>
            /// <returns>Posicin en la que se ha insertado el nuevo nodo.</returns>
            public int Add(RtfTreeNode node)
            {
                InnerList.Add(node);

                return (InnerList.Count - 1);
            }

            /// <summary>
            /// Inserta un nuveo nodo en una posicin determinada de la coleccin.
            /// </summary>
            /// <param name="index">Posicin en la que insertar el nodo.</param>
            /// <param name="node">Nuevo nodo a insertar.</param>
            public void Insert(int index, RtfTreeNode node)
            {
                InnerList.Insert(index, node);
            }

            /// <summary>
            /// Indizador de la clase RtfNodeCollection. 
            /// Devuelve el nodo que ocupa la posicin 'index' dentro de la coleccin.
            /// </summary>
            public RtfTreeNode this[int index]
            {
                get
                {
                    return (RtfTreeNode)InnerList[index];
                }
                set
                {
                    InnerList[index] = value;
                }
            }

            /// <summary>
            /// Devuelve el ndice del nodo pasado como parmetro dentro de la lista de nodos de la coleccin.
            /// </summary>
            /// <param name="node">Nodo a buscar en la coleccin.</param>
            /// <returns>Indice del nodo buscado. Devolver el valor -1 en caso de no encontrarse el nodo dentro de la coleccin.</returns>
            public int IndexOf(RtfTreeNode node)
            {
                return InnerList.IndexOf(node);
            }

            /// <summary>
            /// Devuelve el ndice del nodo pasado como parmetro dentro de la lista de nodos de la coleccin.
            /// </summary>
            /// <param name="node">Nodo a buscar en la coleccin.</param>
            /// <param name="startIndex">Posicin dentro de la coleccin a partir del que se buscar.</param>
            /// <returns>Indice del nodo buscado. Devolver el valor -1 en caso de no encontrarse el nodo dentro de la coleccin.</returns>
            public int IndexOf(RtfTreeNode node, int startIndex)
            {
                return InnerList.IndexOf(node, startIndex);
            }

            /// <summary>
            /// Devuelve el ndice del primer nodo de la coleccin cuya clave sea la pasada como parmetro.
            /// </summary>
            /// <param name="key">Clave a buscar en la coleccin.</param>
            /// <returns>Indice del nodo buscado. Devolver el valor -1 en caso de no encontrarse el nodo dentro de la coleccin.</returns>
            public int IndexOf(string key)
            {
                int intFoundAt = -1;

                if (InnerList.Count > 0)
                {
                    for (int intIndex = 0; intIndex < InnerList.Count; intIndex++)
                    {
                        if (((RtfTreeNode)InnerList[intIndex]).NodeKey == key)
                        {
                            intFoundAt = intIndex;
                            break;
                        }
                    }
                }

                return intFoundAt;
            }

            /// <summary>
            /// Devuelve el ndice del primer nodo de la coleccin cuya clave sea la pasada como parmetro.
            /// </summary>
            /// <param name="key">Clave a buscar en la coleccin.</param>
            /// <param name="startIndex">Posicin dentro de la coleccin a partir del que se buscar.</param>
            /// <returns>Indice del nodo buscado. Devolver el valor -1 en caso de no encontrarse el nodo dentro de la coleccin.</returns>
            public int IndexOf(string key, int startIndex)
            {
                int intFoundAt = -1;

                if (InnerList.Count > 0)
                {
                    for (int intIndex = startIndex; intIndex < InnerList.Count; intIndex++)
                    {
                        if (((RtfTreeNode)InnerList[intIndex]).NodeKey == key)
                        {
                            intFoundAt = intIndex;
                            break;
                        }
                    }
                }

                return intFoundAt;
            }

            /// <summary>
            /// Aade al final de la coleccin una nueva lista de nodos.
            /// </summary>
            /// <param name="collection">Nueva lista de nodos a aadir a la coleccin actual.</param>
            public void AddRange(RtfNodeCollection collection)
            {
                InnerList.AddRange(collection);
            }

            /// <summary>
            /// Elimina un conjunto de nodos adyacentes de la coleccin.
            /// </summary>
            /// <param name="index">ndice del primer nodo del conjunto a eliminar.</param>
            /// <param name="count">Nmero de nodos a eliminar.</param>
            public void RemoveRange(int index, int count)
            {
                InnerList.RemoveRange(index, count);
            }

            #endregion
        }
    }
}
