/********************************************************************************
 *   This file is part of NRtfTree Library.
 *
 *   NRtfTree Library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   NRtfTree Library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.
 ********************************************************************************/

/********************************************************************************
 * Library:		NRtfTree
 * Version:     v0.3.0
 * Date:		01/05/2009
 * Copyright:   2006-2009 Salvador Gomez
 * E-mail:      sgoliver.net@gmail.com
 * Home Page:	http://www.sgoliver.net
 * SF Project:	http://nrtftree.sourceforge.net
 *				http://sourceforge.net/projects/nrtftree
 * Class:		SarParser
 * Description:	Procesador abstracto utilizado por la clase RtfReader.
 * ******************************************************************************/

using System;

namespace Net.Sgoliver.NRtfTree
{
    namespace Core
    {
        /// <summary>
        /// Esta clase, utilizada por RtfReader, contiene todos los mtodos necesarios para tratar cada uno de 
        /// los tipos de elementos presentes en un documento RTF. Estos mtodos sern llamados automticamente 
        /// durante el anlisis del documento RTF realizado por la clase RtfReader.
        /// </summary>
        public abstract class SarParser
        {
            /// <summary>
            /// Este mtodo se llama una sla vez al comienzo del anlisis del documento RTF.
            /// </summary>
            public abstract void StartRtfDocument();
            /// <summary>
            /// Este mtodo se llama una sla vez al final del anlisis del documento RTF.
            /// </summary>
            public abstract void EndRtfDocument();
            /// <summary>
            /// Este mtodo se llama cada vez que se lee una llave de comienzo de grupo RTF.
            /// </summary>
            public abstract void StartRtfGroup();
            /// <summary>
            /// Este mtodo se llama cada vez que se lee una llave de fin de grupo RTF.
            /// </summary>
            public abstract void EndRtfGroup();
            /// <summary>
            /// Este mtodo se llama cada vez que se lee una palabra clave RTF.
            /// </summary>
            /// <param name="key">Palabra clave leida del documento.</param>
            /// <param name="hasParameter">Indica si la palabra clave va acompaada de un parmetro.</param>
            /// <param name="parameter">
            /// Parmetro que acompaa a la palabra clave. En caso de que la palabra clave no vaya acompaada
            /// de ningn parmetro, es decir, que el campo hasParam sea 'false', 
            /// este campo contendr el valor 0.
            /// </param>
            public abstract void RtfKeyword(string key, bool hasParameter, int parameter);
            /// <summary>
            /// Este mtodo se llama cada vez que se lee un smbolo de Control RTF.
            /// </summary>
            /// <param name="key">Smbolo de Control leido del documento.</param>
            /// <param name="hasParameter">Indica si el smbolo de Control va acompaado de un parmetro.</param>
            /// <param name="parameter">
            /// Parmetro que acompaa al smbolo de Control. En caso de que el smbolo de Control no vaya acompaado
            /// de ningn parmetro, es decir, que el campo hasParam sea 'false', 
            /// este campo contendr el valor 0.
            /// </param>
            public abstract void RtfControl(string key, bool hasParameter, int parameter);
            /// <summary>
            /// Este mtodo se llama cada vez que se lee un fragmento de Texto del documento RTF.
            /// </summary>
            /// <param name="text">Texto leido del documento.</param>
            public abstract void RtfText(string text);
        }
    }
}
