﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text;
using Microsoft.Office.Core;
using Microsoft.Office.Interop.PowerPoint;
using Microsoft.Office.Tools.Ribbon;
using Office = Microsoft.Office.Core;
using PowerPoint = Microsoft.Office.Interop.PowerPoint;
using Alsing.SourceCode;
using Net.Sgoliver.NRtfTree;
using Row = Alsing.SourceCode.Row;
using TextStyle = Alsing.SourceCode.TextStyle;
using Net.Sgoliver.NRtfTree.Util;
using System.Windows.Forms;

// TODO:  Follow these steps to enable the Ribbon (XML) item:

// 1: Copy the following code block into the ThisAddin, ThisWorkbook, or ThisDocument class.

//  protected override Microsoft.Office.Core.IRibbonExtensibility CreateRibbonExtensibilityObject()
//  {
//      return new SyntaxColoringRibbon();
//  }

// 2. Create callback methods in the "Ribbon Callbacks" region of this class to handle user
//    actions, such as clicking a button. Note: if you have exported this Ribbon from the Ribbon designer,
//    move your code from the event handlers to the callback methods and modify the code to work with the
//    Ribbon extensibility (RibbonX) programming model.

// 3. Assign attributes to the control tags in the Ribbon XML file to identify the appropriate callback methods in your code.  

// For more information, see the Ribbon XML documentation in the Visual Studio Tools for Office Help.


namespace SyntaxColoring
{
  [ComVisible(true)]
  public class SyntaxColoringRibbon : Office.IRibbonExtensibility
  {
    private Office.IRibbonUI ribbon;

    public SyntaxColoringRibbon() { }

    #region IRibbonExtensibility Members

    public string GetCustomUI(string ribbonID)
    {
      return GetResourceText("SyntaxColoring.SyntaxColoringRibbon.xml");
    }

    #endregion

    private Dictionary<string, string> syntaxDefinitions;

    public void Ribbon_Load(IRibbonUI ribbonUI)
    {
      this.ribbon = ribbonUI;
      syntaxDefinitions = new Dictionary<string, string>();
      syntaxDefinitions["C#"] = @"SyntaxColoring.syn.C#.syn";
      syntaxDefinitions["VBNET"] = @"SyntaxColoring.syn.VBNET.syn";
      syntaxDefinitions["CSS"] = @"SyntaxColoring.syn.CSS.syn";
      syntaxDefinitions["HTML"] = @"SyntaxColoring.syn.ASP.syn";
      syntaxDefinitions["JS"] = @"SyntaxColoring.syn.JavaScript.syn";
      syntaxDefinitions["XML"] = @"SyntaxColoring.syn.XML.syn";
    }

    private string syntaxDefinition = @"SyntaxColoring.C#.syn";

    public void Format_Clicked(IRibbonControl button)
    {
      string language = button.Tag as string;
      if (null == language) return;
      syntaxDefinition = syntaxDefinitions[language];
      Format(button);
    }
    private void Format(IRibbonControl button)
    {
      try
      {
        var ppt = button.Context as PowerPoint.DocumentWindow;
        if (null == ppt) return;
        var app = ppt.Application;
        if (null == app) return;
        var actw = app.ActiveWindow;
        if (null == actw) return;
        var selection = actw.Selection;
        if (null == selection) return;
        var shape = selection.ShapeRange;
        if (null == shape) return;
        var textRange = selection.TextRange;
        if (textRange != null && String.IsNullOrEmpty(textRange.Text))
        {
          if (null != shape.TextFrame)
            textRange = shape.TextFrame.TextRange;
        }
        if (null == textRange) return;
        //var selectedText = selection.
        var text = textRange.Text;
        text = PreprocessText(text);
        Format(shape, text);
      }
      catch
      { }

    }

    private static string PreprocessText(string text)
    {
      text = text.Replace("\r", Environment.NewLine);
      text = text.Replace("\v", Environment.NewLine);
      text = text.Replace(((char)8220) + String.Empty, "\"");
      text = text.Replace(((char)8221) + String.Empty, "\"");
      text = text.Replace("\t", "  ");
      return text;
    }

    private void Format(PowerPoint.ShapeRange shape, string text)
    {
      // cache content of the clipboard
      object data = Clipboard.GetDataObject();

      var da = new DataObject();

      var formattedText = FormatRtf(text);
      da.SetData(DataFormats.Rtf, formattedText);
      Clipboard.SetDataObject(da);

      shape.TextFrame.TextRange.PasteSpecial(PpPasteDataType.ppPasteRTF, MsoTriState.msoFalse, "", 0, "brol",
                                             MsoTriState.msoFalse);

      // restore the original content of the clipboard
      if (null != data) Clipboard.SetDataObject(data);

      shape.BackgroundStyle = MsoBackgroundStyleIndex.msoBackgroundStylePreset1;
      shape.TextEffect.Alignment = MsoTextEffectAlignment.msoTextEffectAlignmentLeft;
      shape.TextFrame.TextRange.ParagraphFormat.Bullet.Type = PpBulletType.ppBulletNone;
      shape.TextFrame.TextRange.Font.Shadow = MsoTriState.msoCTrue;
      shape.TextFrame.TextRange.Font.Size = 22;
      shape.TextFrame.TextRange.Font.Bold = MsoTriState.msoFalse;
      shape.TextFrame.TextRange.Font.Name = "Consolas";
      shape.TextFrame.AutoSize = PpAutoSize.ppAutoSizeShapeToFitText;
    }

    private string FormatRtf(string text)
    {
      SyntaxDocument doc = Parse(text);

      return CreateRtfString(doc);
    }

    private static string CreateRtfString(SyntaxDocument doc)
    {
      RtfDocument r = new RtfDocument(null);

      for (int i = 0; i <= doc.Count; i++)
      {
        Row row = doc[i];
        if (null == row) break;

        r.AddText(new String(' ', row.Depth * 2));

        foreach (Word w in row)
        {
          RtfCharFormat charFormat = new RtfCharFormat();

          if (w.Style != null)
          {
            charFormat.Bold = w.Style.Bold;
            charFormat.Color = w.Style.ForeColor;
            charFormat.Italic = w.Style.Italic;
            charFormat.Underline = w.Style.Underline;
          }

          switch (w.Type)
          {
            case WordType.Word:
              r.AddText(w.Text, charFormat);
              break; // add word
            case WordType.Space:
              r.AddText(" ");
              break; // add space
            case WordType.Tab:
              r.AddText("  ");
              break; // add tab
          }
        }
        if (i < doc.Count-1)
          r.AddNewParagraph();
      }
      return r.GetRtfString();
    }

    private SyntaxDocument Parse(string text)
    {
      SyntaxDocument doc = new SyntaxDocument();
      doc.SetSyntaxFromEmbeddedResource(Assembly.GetExecutingAssembly(), syntaxDefinition);

      doc.Text = text;
      doc.AutoIndentSegment(new Span(doc[0]));
      doc.ParseAll();
      return doc;
    }

    #region Helpers

    private static string GetResourceText(string resourceName)
    {
      Assembly asm = Assembly.GetExecutingAssembly();
      string[] resourceNames = asm.GetManifestResourceNames();
      for (int i = 0; i < resourceNames.Length; ++i)
      {
        if (string.Compare(resourceName, resourceNames[i], StringComparison.OrdinalIgnoreCase) == 0)
        {
          using (StreamReader resourceReader = new StreamReader(asm.GetManifestResourceStream(resourceNames[i])))
          {
            if (resourceReader != null)
            {
              return resourceReader.ReadToEnd();
            }
          }
        }
      }
      return null;
    }

    #endregion
  }
}
