﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using Alsing.Windows.Forms.SyntaxBox;
using Microsoft.Office.Core;
using Microsoft.Office.Interop.PowerPoint;
using Microsoft.Office.Tools.Ribbon;
using Office = Microsoft.Office.Core;
using PowerPoint = Microsoft.Office.Interop.PowerPoint;
using Alsing.SourceCode;
using Alsing.Windows.Forms;
using Row = Alsing.SourceCode.Row;
using TextStyle = Alsing.SourceCode.TextStyle;

// TODO:  Follow these steps to enable the Ribbon (XML) item:

// 1: Copy the following code block into the ThisAddin, ThisWorkbook, or ThisDocument class.

//  protected override Microsoft.Office.Core.IRibbonExtensibility CreateRibbonExtensibilityObject()
//  {
//      return new SyntaxColoringRibbon();
//  }

// 2. Create callback methods in the "Ribbon Callbacks" region of this class to handle user
//    actions, such as clicking a button. Note: if you have exported this Ribbon from the Ribbon designer,
//    move your code from the event handlers to the callback methods and modify the code to work with the
//    Ribbon extensibility (RibbonX) programming model.

// 3. Assign attributes to the control tags in the Ribbon XML file to identify the appropriate callback methods in your code.  

// For more information, see the Ribbon XML documentation in the Visual Studio Tools for Office Help.


namespace SyntaxColoring
{
    [ComVisible(true)]
    public class SyntaxColoringRibbon : Office.IRibbonExtensibility
    {
        private Office.IRibbonUI ribbon;

        public SyntaxColoringRibbon() { }

        #region IRibbonExtensibility Members

        public string GetCustomUI(string ribbonID)
        {
            return GetResourceText("SyntaxColoring.SyntaxColoringRibbon.xml");
        }

        #endregion

        #region Ribbon Callbacks
        //Create callback methods here. For more information about adding callback methods, select the Ribbon XML item in Solution Explorer and then press F1

        public void Ribbon_Load(IRibbonUI ribbonUI)
        {
            this.ribbon = ribbonUI;
        }

        public void Format_Clicked(IRibbonControl button)
        {
            var ppt = button.Context as PowerPoint.DocumentWindow;
            if (null == ppt) return;
            var app = ppt.Application;
            if (null == app) return;
            var actw = app.ActiveWindow;
            if (null == actw) return;
            var selection = actw.Selection;
            if (null == selection) return;
            var shape = selection.ShapeRange;
            if (null == shape) return;
            var textRange = selection.TextRange;
            if (textRange != null && String.IsNullOrEmpty(textRange.Text))
            {
                if (null != shape.TextFrame)
                    textRange = shape.TextFrame.TextRange;
            }
            if (null == textRange) return;
            var text = textRange.Text;
            text = text.Replace('\v' + string.Empty, Environment.NewLine);
            text = text.Replace('\t' + string.Empty, "  ");
            Format(shape, text);
        }

        private void Format(PowerPoint.ShapeRange shape, string text)
        {
            var formattedText = FormatRtf(text, "Consolas");

            object data = Clipboard.GetDataObject();

            var da = new DataObject();
            da.SetData(DataFormats.Rtf, formattedText);
            Clipboard.SetDataObject(da);

            shape.TextFrame.TextRange.PasteSpecial(PpPasteDataType.ppPasteRTF, MsoTriState.msoFalse, "", 0, "brol",
                                                   MsoTriState.msoFalse);

            if ( null != data ) Clipboard.SetDataObject(data);

            shape.BackgroundStyle = MsoBackgroundStyleIndex.msoBackgroundStylePreset1;
            shape.TextEffect.Alignment = MsoTextEffectAlignment.msoTextEffectAlignmentLeft;
            shape.TextFrame.TextRange.Font.Shadow = MsoTriState.msoCTrue;
            shape.TextFrame.TextRange.Font.Size = 22;
            shape.TextFrame.TextRange.Font.Bold = MsoTriState.msoFalse;
            shape.TextFrame.AutoSize = PpAutoSize.ppAutoSizeShapeToFitText;

        }

        private string FormatRtf(string text, string fontName)
        {
            SyntaxDocument doc = new SyntaxDocument();
            doc.SetSyntaxFromEmbeddedResource(Assembly.GetExecutingAssembly(), @"SyntaxColoring.C#.syn");

            doc.Text = text;

            TextStyle[] styles = doc.Parser.SyntaxDefinition.Styles;
            doc.ParseAll();
            //doc.AutoIndentSegment(new Span(doc[0]));


            int r1 = 0;
            int r2 = doc.Count - 1;
            int c1 = 0;
            int c2 = doc[doc.Count - 1].Text.Length;

            var sb = new StringBuilder();
            sb.Append(@"{\rtf1\ansi\ansicpg1252\deff0\deflang1053{\fonttbl{\f0\fmodern\fprq1\fcharset0 " + fontName +
                      @";}}");
            sb.Append(@"{\colortbl ;");

            foreach (TextStyle ts in styles)
            {
                sb.AppendFormat("\\red{0}\\green{1}\\blue{2};", ts.ForeColor.R, ts.ForeColor.G, ts.ForeColor.B);
                sb.AppendFormat("\\red{0}\\green{1}\\blue{2};", ts.BackColor.R, ts.BackColor.G, ts.BackColor.B);
            }

            sb.Append(@";}");
            sb.Append(@"\viewkind4\uc1\pard\f0\fs20");


            bool Done = false;
            for (int i = r1; i <= r2; i++)
            {
                Row row = doc[i];


                foreach (Word w in row)
                {
                    if (i == r1 && w.Column + w.Text.Length < c1)
                        continue;

                    bool IsFirst = (i == r1 && w.Column <= c1 && w.Column + w.Text.Length > c1);
                    bool IsLast = (i == r2 && w.Column < c2 && w.Column + w.Text.Length > c2);


                    if (w.Type == WordType.Word && w.Style != null)
                    {
                        int clrindex = Array.IndexOf(styles, w.Style);
                        clrindex *= 2;
                        clrindex++;

                        sb.Append("{\\cf" + clrindex.ToString(CultureInfo.InvariantCulture));
                        if (!w.Style.Transparent)
                        {
                            sb.Append("\\highlight" + (clrindex + 1).ToString(CultureInfo.InvariantCulture));
                        }
                        sb.Append(" ");
                    }

                    if (w.Style != null)
                    {
                        if (w.Style.Bold)
                            sb.Append(@"\b ");
                        if (w.Style.Underline)
                            sb.Append(@"\ul ");
                        if (w.Style.Italic)
                            sb.Append(@"\i ");
                    }
                    string wordtext = w.Text;

                    if (IsLast)
                        wordtext = wordtext.Substring(0, c2 - w.Column);

                    if (IsFirst)
                        wordtext = wordtext.Substring(c1 - w.Column);


                    wordtext =
                        wordtext.Replace(@"\", @"\\").Replace(@"}", @"\}").Replace(@"{", @"\{");

                    sb.Append(wordtext);

                    if (w.Style != null)
                    {
                        if (w.Style.Bold) sb.Append(@"\b0 ");
                        if (w.Style.Underline)
                            sb.Append(@"\ul0 ");
                        if (w.Style.Italic) sb.Append(@"\i0 ");
                    }

                    if (w.Type == WordType.Word && w.Style != null)
                    {
                        sb.Append("}");
                    }

                    if (IsLast)
                    {
                        Done = true;
                        break;
                    }
                }
                if (Done) break;

                sb.Append(@"\par");
            }
            return sb.ToString();
        }


        #endregion

        #region Helpers

        private static string GetResourceText(string resourceName)
        {
            Assembly asm = Assembly.GetExecutingAssembly();
            string[] resourceNames = asm.GetManifestResourceNames();
            for (int i = 0; i < resourceNames.Length; ++i)
            {
                if (string.Compare(resourceName, resourceNames[i], StringComparison.OrdinalIgnoreCase) == 0)
                {
                    using (StreamReader resourceReader = new StreamReader(asm.GetManifestResourceStream(resourceNames[i])))
                    {
                        if (resourceReader != null)
                        {
                            return resourceReader.ReadToEnd();
                        }
                    }
                }
            }
            return null;
        }

        #endregion
    }
}
